#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Taste of Noise 2Mod01.fsh   by  leon   
//https://www.shadertoy.com/view/fscXDf
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract


// taste of noise 2 by leon denise 2021/10/12
// result of experimentation with organic patterns
// using code from Inigo Quilez, David Hoskins and NuSan
// licensed under hippie love conspiracy
// Dave Hoskins
// https://www.shadertoy.com/view/4djSRW
float hash13(vec3 p3)
{
	p3  = fract(p3 * .1031);
    p3 += dot(p3, p3.zyx + 31.32);
    return fract((p3.x + p3.y) * p3.z);
}

// Inigo Quilez
// https://iquilezles.org/articles/distfunctions
float smin( float d1, float d2, float k ) {
    float h = clamp( 0.5 + 0.5*(d2-d1)/k, 0.0, 1.0 );
    return mix( d2, d1, h ) - k*h*(1.0-h); }
float smoothing(float d1, float d2, float k) { return clamp( 0.5 + 0.5*(d2-d1)/k, 0.0, 1.0 ); }
    

// rotation matrix
mat2 rot(float a) { return mat2(cos(a),-sin(a),sin(a),cos(a)); }

#define repeat(p,r) (mod(p,r)-r/2.)
// global variable
float material;

// sdf
float map (vec3 p)
{
    vec3 pp = p;
    
    // time
    float t = iTime * 0.1;
    
    // travel
    p.z += t;
    
    // rotation parameter
    vec3 angle = vec3(4.,3.,8.) + p;
    
    // domain repeat
    float grid = 1.5;
    p = repeat(p, grid);
    
    // kif
    const int count = 6;
    float a = 1.0;
    float scene = 1000.;
    float shape = 1000.;
    for (int index = 0; index < count; ++index)
    {
        // fold
        p = abs(p)-.4*a;
        
        // rotate
        p.xz *= rot(angle.y/a);
        p.yz *= rot(angle.x/a);
        p.yx *= rot(angle.z/a);
        
        // sphere
        shape = length(p)-.3*a;
        
        // material blending
        material = mix(material, float(index), smoothing(shape, scene, 0.1*a));
        
        // add
        scene = smin(scene, shape, 0.1 * a);
        
        // falloff
        a /= 1.9;
    }
    
    // cylinder hole
    scene = smin(scene, length(pp.xy)-0.15, 0.1);
    
    // shell
    scene = -(scene);
    
    // surface details
    p = repeat(p, 0.03);
    scene -= length(p)*.2;
        
    return scene;
}

// return color from pixel coordinate
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    // reset color
    fragColor = vec4(0);
    material = 0.0;
    
    // camera coordinates
    vec2 uv = (fragCoord.xy - iResolution.xy * 0.5) / iResolution.y;
    vec3 eye = vec3(0,0,-0.2);
    vec2 mouse = iMouse.xy / iResolution.xy;
    eye.xz *= rot(0.4+mouse.x*3.);
    eye.xy *= rot(0.6-mouse.y*3.);
    vec3 z = normalize(-eye);
    vec3 x = normalize(cross(z, vec3(0,1,0)));
    vec3 y = normalize(cross(x, z));
    vec3 ray = normalize(vec3(z * 0.5 + uv.x * x + uv.y * y));
    vec3 pos = eye + ray * .1;
    
    // white noise
    vec3 seed = vec3(gl_FragCoord.xy, iTime);
    float rng = hash13(seed);
    
    // raymarch
    const int steps = 30;
    for (int index = steps; index > 0; --index)
    {
        // volume estimation
        float dist = map(pos);
        if (dist < 0.001)
        {
            float shade = float(index)/float(steps);
            
            // compute normal by NuSan (https://www.shadertoy.com/view/3sBGzV)
            vec2 off=vec2(.001,0);
            vec3 normal = normalize(map(pos)-vec3(map(pos-off.xyy), map(pos-off.yxy), map(pos-off.yyx)));
            
            // Inigo Quilez color palette (https://iquilezles.org/articles/palettes)
            vec3 tint = vec3(1.)+vec3(0.5)*cos(vec3(1,2,3)*material*0.2+pos.z);
            
            // specular lighting
            float ld = dot(normal, -ray)*0.5+0.5;
            vec3 light = vec3(0.196,0.925,0.914) * pow(ld, 10.) * 0.5;
            
            // pixel color
            fragColor.rgb = (tint + light) *  shade;
            
            break;
        }
        
        // dithering
        dist *= 0.8 + 0.1 * rng;
        
        // raymarch
        pos += ray * dist;
    }

/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

